#ifndef _HOME_PLUG_CTL_H
#define _HOME_PLUG_CTL_H
#include "bcmtypes.h"
/** Defines. **/
#define BUFLEN_64 64
#define kHomeplugVersionStringSize           16
#define kHomeplugStringSize                  64
#define kHomeplugMACAddressStringSize        32
#define kHomeplugSNRPerToneStringSize        27632 /* 4 digits per item, 3454 items * 2 paths */
#define kHomeplugFWBuildMsgSize              256

#define DEVCTRLHOMEPLUG_VERSION                    "1.0"
#define HOMEPLUG_VERSION_1_1_STR                   "1.1"
#define HOMEPLUG_VERSION_2_0_STR                   "2.0"
#define HOMEPLUG_VERSION_1_1                        0x00
#define HOMEPLUG_VERSION_2_0                        0x01

#define HOMEPLUG_MAXBITRATE_200                    0x00
#define HOMEPLUG_MAXBITRATE_1000                   0x01
#define HOMEPLUG_MAXBITRATE_1800                   0x02
#define HOMEPLUG_MAXBITRATE_200_U32                (UINT32) 200
#define HOMEPLUG_MAXBITRATE_1000_U32               (UINT32) 1000
#define HOMEPLUG_MAXBITRATE_1800_U32               (UINT32) 1800

#ifdef HOMEPLUG_CHIP_60321
#define PARAM_CONFIG_PLCONFIG_USER_NID             73
#define PARAM_CONFIG_STATINFO_USER_STA_HFID        75
#define PARAM_CONFIG_STATINFO_USER_AVLN_HFID       76
#else
#define PARAM_CONFIG_PLCONFIG_USER_NID             35
#define PARAM_CONFIG_STATINFO_USER_STA_HFID        37
#define PARAM_CONFIG_STATINFO_USER_AVLN_HFID       38
#define PARAM_CONFIG_PROD_TEST                     29
#define PARAM_CONFIG_ODM_PRIVATE_STRING            34
#endif // HOMEPLUG_CHIP_60321

#define PARAM_CONFIG_LCONFIG_USER_NMK	36
#define PARAM_CONFIG_PLCONFIG_MANUFACTORER_DAK1    9
#define PARAM_CONFIG_PLCONFIG_MANUFACTORER_DAK2    10
#define PARAM_CONFIG_PLCONFIG_MANUFACTORER_DAK3    11
#define PARAM_CONFIG_PLCONFIG_MANUFACTORER_DAK4    12

#define PARAM_CONFIG_LED_CONTROL	62
#define NMK_SIZE  (16)

/* LED status */
#define	PLC_LED_OFF	0x0
#define	PLC_LED_ON	0x1

/* LED masks and bits */
#define CTRL_LED_OFF_MASK                     0x00400000
#define mask_CTRL_LED_OFF_unset               0xFFBFFFFF
#define mask_CTRL_LED_ON_unset                0xFFDFFFFF


/* LED masks and bits */
#define BIT_CTRL_LED_OFF                      22
#define BIT_CTRL_LED_ON                       21
#define CTRL_LED_ON_MASK                      0x00200000


/*ETH Link Status*/
#define ETH_LINK_ON						0
#define ETH_LINK_DOWN					1


#define DAK_SIZE              (16)
#define PARAM_ID_1            9
#define PARAM_ID_2            10
#define PARAM_ID_3            11
#define PARAM_ID_4            12

/**************************************************************************************************/
/** More Typedefs. **/
/* UKE command action */
typedef enum UKEAction
{
   UKE_ACTION_START = 0,
   UKE_ACTION_RANDOMIZE_KEY,
   UKE_ACTION_GET_STATUS,
} UKEAction;

typedef enum UKEStatus
{
  UKE_STATUS_SUCCESS = 0,
  UKE_STATUS_FAILED,
  UKE_STATUS_TIMEOUT,
  UKE_STATUS_ONGOING,
  UKE_STATUS_NOT_STARTED,
} UKEStatus;

typedef struct
{
   UINT16   size;
   UINT32   value[BUFLEN_64];
} PARAM_INFO, *PPARAM_INFO;

/*! \brief Discovered PLC device
 */
typedef struct
{
  unsigned char MACAddress[6];  /**< MAC Address */
  char          HFID[65];       /**< HFID */
  unsigned char MMV;            /**< L2 Protocol Version supported */
} HomePlugDiscoveredLocalPLCDevice, *PHomePlugDiscoveredLocalPLCDevice, HomePlugDiscoveredPLCDevice;

/*! \brief HomePlug interface status information
 */
typedef struct
{
    UBOOL8    enable;	/**< Enable */
    char      alias[kHomeplugStringSize];	/**< Alias */
    UINT32    lastChange;	/**< LastChange */
    char      MACAddress[kHomeplugStringSize];	/**< MACAddress */
    char      logicalNetwork[kHomeplugStringSize];	/**< LogicalNetwork */
    char      version[kHomeplugVersionStringSize];	/**< Version */
    char      firmwareVersion[kHomeplugStringSize];	/**< FirmwareVersion */
    char      otherNetworksPresent[kHomeplugStringSize];	/**< OtherNetworksPresent */
    UINT32    maxBitRate;	/**< MaxBitRate */
    UINT32    associatedDeviceNumberOfEntries;	/**< AssociatedDeviceNumberOfEntries */
    char      X_BROADCOM_COM_PLCFwBuildMsg[kHomeplugFWBuildMsgSize]; /**< firmware build message */ 
} HomePlugInterfaceStatus, *PHomePlugInterfaceStatus;

/*! \brief visible HPAV station information
 */
typedef struct
{
   char      MACAddress[kHomeplugMACAddressStringSize]; /**< MACAddress */
   UINT8     bMACAddress[6]; /**< MACAddress in binary format */
   UINT32    txPhyRate;	/**< TxPhyRate */
   UINT8     txBeamformed; /**< tx_beamformed */
   UINT8     txMode;       /**< txMode */
   UINT8     txDevType;    /**< rx_devType */
   UINT32    rxPhyRate;	/**< RxPhyRate */
   UINT8     rxBeamformed; /**< rx_beamformed */
   UINT8     rxMode;       /**< rxMode */
   UINT8     rxDevType;    /**< rxdevType */

   
   char      SNRPerTone[kHomeplugSNRPerToneStringSize]; /**< SNRPerTone */
   UINT32    avgAttenuation; /**< AvgAttenuation */
   char *    endStationMACs; /**< EndStationMACs */
   UBOOL8    active;	/**< Active */
   char      firmwareVersion[kHomeplugStringSize];	/**< X_BROADCOM_COM_FirmwareVersion */
   UINT32    uptime;	/**< X_BROADCOM_COM_Uptime */
   UINT8 *   overview; /**< X_BROADCOM_COM_Overview */
   UINT32    overview_length; /**< X_BROADCOM_COM_Overview len */
} HomePlugStation, *PHomePlugStation;

/*! \brief HomePlug interface assoc devices information
 */
typedef struct
{
   UINT8             NumSTAs; /**< Number of visible HPAV stations */
   HomePlugStation*  Stations; /**< first item in the list of visible HPAV stations */
} HomePlugInterfaceAssocDevices, *PHomePlugInterfaceAssocDevices;

/* STDBY command action */
typedef enum STDBYAction
{
    STDBY_ACTION_BUTTON     = (1 << 0),
    STDBY_ACTION_GPHY_CABLE = (1 << 3),
} STDBYAction;

/**************************************************************************************************/
void devCtrl_homeplugIni();
void devCtrl_homeplugClose();
int devCtrl_homeplugDiscoverLocalPLCDevice(int secs, PHomePlugDiscoveredLocalPLCDevice localPLCDevice);
int devCtrl_homeplugSetLocalPlcDeviceMac(unsigned char *macAddr);
int devCtl_homeplugGetLocalDeviceVersion(char * fw_version);
int devCtl_homeplugSetInterfaceNetworkPassword(char* network_password);
int devCtl_homeplugSetInterfaceHfid(char* hfid);
int devCtl_homeplugSetInterfaceLogicalNetwork(char* logical_network);
int devCtl_homeplugUKEAction(UKEAction action, UKEStatus *ret_status);
int devCtl_homeplugGetInterfaceAssocDeviceData(PHomePlugInterfaceAssocDevices data);
int devCtl_homeplugSTDBYAction(STDBYAction action);
int devCtl_homeplugSetRemoteNetworkPassword(char* password, char *mac);
int devCtl_homeplugSetRemoteHfid(char* hfid, char* mac);
int devCtrl_homeplugDiscoverAllPLCDevice(int secs, tS_DiscoveredPLCDevice* deviceList);
int devCtrl_homeplugRemoteDeviceLedStatusSet(char* mac, int DeviceLedStatus);
int devCtrl_homeplugRemoteDeviceLedStatusGet(char * mac, int *DeviceLedStatus);
int devCtrl_homeplugDeviceLedStatusSet(int DeviceLedStatus);
int devCtrl_homeplugDeviceLedStatusGet(int *DeviceLedStatus);
int devCtl_homeplugGetRemoteInterfaceIp(char*mac, unsigned int *ip);
int devCtl_homeplugSetInterfaceIp(unsigned int *ip);
int devCtl_homeplugGetInterfaceIp(unsigned int *ip);
int devCtl_homeplugRestart();
int devCtl_homeplugGetParam(unsigned short param_id, int param_len, char *param);
int devCtl_homeplugSetInterfaceFactoryDak(char* dpw);
int devCtl_homeplugSetParam(unsigned short param_id, int param_len, char *param);
int devCtl_homeplugGetCpuTemperature();
int devCtl_homeplugGetRemoteParam(char * mac, unsigned short param_id, int param_len, char *param);
int devCtl_homeplugGetEthPortStatus(int* mii0_linkStatus, int * mii1_linkStatus);

#endif

